/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import dev.lucaargolo.charta.block.ModBlocks;
import dev.lucaargolo.charta.blockentity.CardTableBlockEntity;
import dev.lucaargolo.charta.blockentity.ModBlockEntityTypes;
import dev.lucaargolo.charta.datagen.ModChestLootProvider;
import dev.lucaargolo.charta.entity.ModEntityTypes;
import dev.lucaargolo.charta.entity.ModPoiTypes;
import dev.lucaargolo.charta.entity.ModVillagerProfessions;
import dev.lucaargolo.charta.game.CardDeck;
import dev.lucaargolo.charta.game.GameSlot;
import dev.lucaargolo.charta.item.ModCreativeTabs;
import dev.lucaargolo.charta.item.ModDataComponentTypes;
import dev.lucaargolo.charta.item.ModItems;
import dev.lucaargolo.charta.menu.ModMenus;
import dev.lucaargolo.charta.network.CardContainerSlotClickPayload;
import dev.lucaargolo.charta.network.CardDecksPayload;
import dev.lucaargolo.charta.network.CardPlayPayload;
import dev.lucaargolo.charta.network.CardTableSelectGamePayload;
import dev.lucaargolo.charta.network.GameLeavePayload;
import dev.lucaargolo.charta.network.GameSlotCompletePayload;
import dev.lucaargolo.charta.network.GameSlotPositionPayload;
import dev.lucaargolo.charta.network.GameSlotResetPayload;
import dev.lucaargolo.charta.network.GameStartPayload;
import dev.lucaargolo.charta.network.ImagesPayload;
import dev.lucaargolo.charta.network.LastFunPayload;
import dev.lucaargolo.charta.network.PlayerOptionsPayload;
import dev.lucaargolo.charta.network.TableScreenPayload;
import dev.lucaargolo.charta.network.UpdateCardContainerCarriedPayload;
import dev.lucaargolo.charta.network.UpdateCardContainerSlotPayload;
import dev.lucaargolo.charta.resources.CardDeckResource;
import dev.lucaargolo.charta.resources.CardImageResource;
import dev.lucaargolo.charta.resources.CardSuitResource;
import dev.lucaargolo.charta.sound.ModSounds;
import dev.lucaargolo.charta.utils.CardImage;
import dev.lucaargolo.charta.utils.PlayerOptionData;
import dev.lucaargolo.charta.utils.SuitImage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2583;
import net.minecraft.class_2818;
import net.minecraft.class_2940;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3264;
import net.minecraft.class_3781;
import net.minecraft.class_3785;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5497;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class Charta
implements ModInitializer {
    private static final class_5321<class_5497> EMPTY_PROCESSOR_LIST_KEY = class_5321.method_29179((class_5321)class_7924.field_41247, (class_2960)class_2960.method_60656((String)"empty"));
    public static final String MOD_ID = "charta";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final class_2583 SYMBOLS = class_2583.field_24360.method_27704(Charta.id("symbols"));
    public static final class_2583 MINERCRAFTORY = class_2583.field_24360.method_27704(Charta.id("minercraftory"));
    public static final class_2960 MISSING_DECK = Charta.id("missing_deck");
    public static final class_2960 MISSING_SUIT = Charta.id("missing_suit");
    public static final class_2960 MISSING_CARD = Charta.id("missing_card");
    public static final class_2960 MISSING_GAME = Charta.id("missing_game");
    public static final CardSuitResource CARD_SUITS = new CardSuitResource();
    public static final CardImageResource CARD_IMAGES = new CardImageResource("card");
    public static final CardImageResource DECK_IMAGES = new CardImageResource("deck");
    public static final CardDeckResource CARD_DECKS = new CardDeckResource();
    public static class_2940<Boolean> MOB_IRON_LEASH;

    public void onInitialize() {
        ModBlocks.register();
        ModItems.register();
        ModEntityTypes.register();
        ModPoiTypes.register();
        ModVillagerProfessions.register();
        ModBlockEntityTypes.register();
        ModMenus.register();
        ModCreativeTabs.register();
        ModDataComponentTypes.register();
        ModSounds.register();
        Charta.registerPayloads();
        Charta.registerEvents();
        Charta.registerLootModifiers();
    }

    private static void registerLootModifiers() {
        ModChestLootProvider chestLoot = new ModChestLootProvider(null);
        LinkedHashMap builders = new LinkedHashMap();
        chestLoot.method_10399(builders::put);
        LootTableEvents.MODIFY.register((key, builder, source, provider) -> {
            String id;
            Object mod;
            if (source.isBuiltin() && (mod = (id = key.method_29177().toString()).equals("minecraft:chests/simple_dungeon") ? (class_52.class_53)builders.get(ModChestLootProvider.SIMPLE_DUNGEON_DECKS) : (id.equals("minecraft:chests/desert_pyramid") ? (class_52.class_53)builders.get(ModChestLootProvider.DESERT_PYRAMID_DECKS) : (id.equals("minecraft:chests/abandoned_mineshaft") ? (class_52.class_53)builders.get(ModChestLootProvider.ABANDONED_MINESHAFT_DECKS) : null))) != null) {
                ImmutableList functions;
                ImmutableList pools = mod.field_949.build();
                if (!pools.isEmpty()) {
                    LOGGER.info("Modifying {} with {} pools", (Object)key, (Object)pools.size());
                    builder.pools((Collection)pools);
                }
                if (!(functions = mod.field_951.build()).isEmpty()) {
                    LOGGER.info("Modifying {} with {} functions", (Object)key, (Object)functions.size());
                    builder.apply((Collection)functions);
                }
            }
        });
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    private static void registerPayloads() {
        Charta.registrarPlayToClient(ImagesPayload.TYPE, ImagesPayload.STREAM_CODEC, ImagesPayload::handleClient);
        Charta.registrarPlayToClient(CardDecksPayload.TYPE, CardDecksPayload.STREAM_CODEC, CardDecksPayload::handleClient);
        Charta.registrarPlayToClient(UpdateCardContainerSlotPayload.TYPE, UpdateCardContainerSlotPayload.STREAM_CODEC, UpdateCardContainerSlotPayload::handleClient);
        Charta.registrarPlayToClient(UpdateCardContainerCarriedPayload.TYPE, UpdateCardContainerCarriedPayload.STREAM_CODEC, UpdateCardContainerCarriedPayload::handleClient);
        Charta.registrarPlayToClient(TableScreenPayload.TYPE, TableScreenPayload.STREAM_CODEC, TableScreenPayload::handleClient);
        Charta.registrarPlayToClient(GameSlotCompletePayload.TYPE, GameSlotCompletePayload.STREAM_CODEC, GameSlotCompletePayload::handleClient);
        Charta.registrarPlayToClient(GameSlotPositionPayload.TYPE, GameSlotPositionPayload.STREAM_CODEC, GameSlotPositionPayload::handleClient);
        Charta.registrarPlayToClient(GameSlotResetPayload.TYPE, GameSlotResetPayload.STREAM_CODEC, GameSlotResetPayload::handleClient);
        Charta.registrarPlayToClient(GameStartPayload.TYPE, GameStartPayload.STREAM_CODEC, GameStartPayload::handleClient);
        Charta.registrarPlayToClient(CardPlayPayload.TYPE, CardPlayPayload.STREAM_CODEC, CardPlayPayload::handleClient);
        Charta.registrarPlayToServer(CardContainerSlotClickPayload.TYPE, CardContainerSlotClickPayload.STREAM_CODEC, CardContainerSlotClickPayload::handleServer);
        Charta.registrarPlayToServer(CardTableSelectGamePayload.TYPE, CardTableSelectGamePayload.STREAM_CODEC, CardTableSelectGamePayload::handleServer);
        Charta.registrarPlayBidirectional(LastFunPayload.TYPE, LastFunPayload.STREAM_CODEC, LastFunPayload::handleClient, LastFunPayload::handleServer);
        Charta.registrarPlayBidirectional(PlayerOptionsPayload.TYPE, PlayerOptionsPayload.STREAM_CODEC, PlayerOptionsPayload::handleClient, PlayerOptionsPayload::handleServer);
        Charta.registrarPlayBidirectional(GameLeavePayload.TYPE, GameLeavePayload.STREAM_CODEC, GameLeavePayload::handleClient, GameLeavePayload::handleServer);
    }

    private static <T extends class_8710> void registrarPlayToClient(class_8710.class_9154<T> type, class_9139<ByteBuf, T> codec, BiConsumer<class_1657, T> handler) {
        PayloadTypeRegistry.playS2C().register(type, codec);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            Charta.registerClientReceiver(type, handler);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static <T extends class_8710> void registerClientReceiver(class_8710.class_9154<T> type, BiConsumer<class_1657, T> handler) {
        ClientPlayNetworking.registerGlobalReceiver(type, (payload, ctx) -> ctx.client().execute(() -> handler.accept((class_1657)ctx.player(), (Object)payload)));
    }

    private static <T extends class_8710> void registrarPlayToServer(class_8710.class_9154<T> type, class_9139<ByteBuf, T> codec, BiConsumer<class_1657, T> handler) {
        PayloadTypeRegistry.playC2S().register(type, codec);
        ServerPlayNetworking.registerGlobalReceiver(type, (payload, ctx) -> ctx.server().execute(() -> handler.accept((class_1657)ctx.player(), (Object)payload)));
    }

    private static <T extends class_8710> void registrarPlayBidirectional(class_8710.class_9154<T> type, class_9139<ByteBuf, T> codec, BiConsumer<class_1657, T> clientHandler, BiConsumer<class_1657, T> serverHandler) {
        Charta.registrarPlayToClient(type, codec, clientHandler);
        Charta.registrarPlayToServer(type, codec, serverHandler);
    }

    private static void registerEvents() {
        ServerLifecycleEvents.SERVER_STARTING.register(GameEvents::serverAboutToStart);
        ServerPlayConnectionEvents.JOIN.register(GameEvents::onPlayerJoined);
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register(GameEvents::onDatapackReload);
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register((a, b) -> ModVillagerProfessions.registerVillagerTrades());
        GameEvents.addReloadListeners(ResourceManagerHelper.get((class_3264)class_3264.field_14190));
    }

    private static void addBuildingToPool(class_2378<class_3785> templatePoolRegistry, class_2378<class_5497> processorListRegistry, class_2960 poolRL, String nbtPieceRL, int weight) {
        class_6880.class_6883 emptyProcessorList = processorListRegistry.method_40290(EMPTY_PROCESSOR_LIST_KEY);
        class_3785 pool = (class_3785)templatePoolRegistry.method_10223(poolRL);
        if (pool == null) {
            return;
        }
        class_3781 piece = (class_3781)class_3781.method_30426((String)nbtPieceRL, (class_6880)emptyProcessorList).apply(class_3785.class_3786.field_16687);
        for (int i = 0; i < weight; ++i) {
            pool.field_16680.add((Object)piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.field_16864);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
        pool.field_16864 = listOfPieceEntries;
    }

    public static class GameEvents {
        public static void serverAboutToStart(MinecraftServer server) {
            class_5455.class_6890 registryAccess = server.method_30611();
            class_2378 templatePoolRegistry = (class_2378)registryAccess.method_33310(class_7924.field_41249).orElseThrow();
            class_2378 processorListRegistry = (class_2378)registryAccess.method_33310(class_7924.field_41247).orElseThrow();
            Charta.addBuildingToPool((class_2378<class_3785>)templatePoolRegistry, (class_2378<class_5497>)processorListRegistry, class_2960.method_12829((String)"minecraft:village/plains/houses"), "charta:plains_card_bar", 50);
            Charta.addBuildingToPool((class_2378<class_3785>)templatePoolRegistry, (class_2378<class_5497>)processorListRegistry, class_2960.method_12829((String)"minecraft:village/desert/houses"), "charta:desert_card_bar", 50);
            Charta.addBuildingToPool((class_2378<class_3785>)templatePoolRegistry, (class_2378<class_5497>)processorListRegistry, class_2960.method_12829((String)"minecraft:village/taiga/houses"), "charta:taiga_card_bar", 40);
            Charta.addBuildingToPool((class_2378<class_3785>)templatePoolRegistry, (class_2378<class_5497>)processorListRegistry, class_2960.method_12829((String)"minecraft:village/savanna/houses"), "charta:savanna_card_bar", 60);
        }

        public static void addReloadListeners(ResourceManagerHelper event) {
            event.registerReloadListener((IdentifiableResourceReloadListener)CARD_SUITS);
            event.registerReloadListener((IdentifiableResourceReloadListener)CARD_IMAGES);
            event.registerReloadListener((IdentifiableResourceReloadListener)DECK_IMAGES);
            event.registerReloadListener((IdentifiableResourceReloadListener)CARD_DECKS);
        }

        public static void onChunkSent(class_3222 player, class_2818 chunk) {
            chunk.method_12214().forEach((pos, blockEntity) -> {
                if (blockEntity instanceof CardTableBlockEntity) {
                    CardTableBlockEntity cardTable = (CardTableBlockEntity)((Object)blockEntity);
                    int count = cardTable.getSlotCount();
                    for (int i = 0; i < count; ++i) {
                        GameSlot slot = cardTable.getSlot(i);
                        GameSlotCompletePayload payload = new GameSlotCompletePayload((class_2338)pos, i, slot);
                        ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
                    }
                }
            });
        }

        public static void onPlayerJoined(class_3244 handler, PacketSender sender, MinecraftServer server) {
            class_3222 serverPlayer = handler.method_32311();
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new ImagesPayload(new HashMap<class_2960, SuitImage>(CARD_SUITS.getImages()), new HashMap<class_2960, CardImage>(CARD_IMAGES.getImages()), new HashMap<class_2960, CardImage>(DECK_IMAGES.getImages())));
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new CardDecksPayload(new LinkedHashMap<class_2960, CardDeck>(CARD_DECKS.getDecks())));
            PlayerOptionData data = (PlayerOptionData)serverPlayer.field_13995.method_30002().method_17983().method_17924(PlayerOptionData.factory(), "charta_player_options");
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new PlayerOptionsPayload(data.getPlayerOptions(serverPlayer)));
        }

        public static void onDatapackReload(class_3222 player, boolean joined) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new ImagesPayload(new HashMap<class_2960, SuitImage>(CARD_SUITS.getImages()), new HashMap<class_2960, CardImage>(CARD_IMAGES.getImages()), new HashMap<class_2960, CardImage>(DECK_IMAGES.getImages())));
            ServerPlayNetworking.send((class_3222)player, (class_8710)new CardDecksPayload(new LinkedHashMap<class_2960, CardDeck>(CARD_DECKS.getDecks())));
        }
    }
}

